#include <bits/stdc++.h>

using namespace std;

#ifdef SG
	#include "debug/debug.h"
#else
	#define debug(...)
#endif

#define forn(i,n) for (int i = 0; i < int(n); ++i)
#define ford(i,n) for (int i = int(n) - 1; i >= 0; --i)

#define mp make_pair
#define pb push_back
#define fs first
#define sc second
#define ve vector
#define pa pair

#define sz(a) int((a).size())
#define all(a) (a).begin(), (a).end()

typedef long long ll;
typedef unsigned long long ull;
typedef long double ld;
typedef pair<int, int> pii;
typedef vector<int> vi;

struct Edge {
	int u, v, w;
	Edge () {}
	Edge (int u, int v, int w): u(u), v(v), w(w) {
	}
};

struct Input {
	int n, m;
	vector<Edge> ed;
	
	bool read () {
		if (!(cin >> n >> m)) {
			return false;
		}
		for (int i = 0; i < m; ++i) {	
			int u, v, w;
			scanf("%d%d%d", &u, &v, &w);
			--u, --v;
			ed.pb(Edge(u, v, w));	
		}
		
		return 1;
	}
	
	void init (Input const & input) {
		*this = input;
	}
};

struct Data: Input {
	vector<int> ans;
	
	void write () {
		printf("%d\n", sz(ans));
		for (int i = 0; i < sz(ans); ++i) {
			if (i != 0) {
				printf(" ");
			}
			printf("%d", ans[i] + 1);
		}
		printf("\n");
	}
	
	virtual void solve() {}
	virtual void clear() {}
};

const int N = 2e4;
const int M = 1e5;
const int inf = 2e9 + 1;

struct Solution: Data {
	vector<int> g[N];
	int d[N];

	vector<pii> h[N], hT[N];	
	bool was[N];
	
	void dfsT (int u) {
		was[u] = true;
		for (int i = 0; i < sz(hT[u]); ++i) {
			int v = hT[u][i].fs;
			if (!was[v]) {
				dfsT(v);
			}
		}
	}
	
	bool ok (int u, int v) {
		return d[u] < inf && was[v];
	}
	
	void solve () {
		for (int i = 0; i < m; ++i) {
			int u = ed[i].u, v = ed[i].v;
			g[u].pb(i);
			g[v].pb(i);
		}
		fill(d, d + n, inf);
		set<pii> t;
		t.insert(mp(0, 0));
		d[0] = 0;
		while (!t.empty()) {
			int u = t.begin()->sc;
			t.erase(t.begin());
			
			for (int i = 0; i < sz(g[u]); ++i) {
				int e = g[u][i];
				int v = ed[e].v, w = ed[e].w;
				if (d[v] > d[u] + w) {
					t.erase(pii(d[v], v));
					d[v] = d[u] + w;
					t.insert(mp(d[v], v));
				}
			}
		}
		
		for (int i = 0; i < m; ++i) {
			int u = ed[i].u, v = ed[i].v, w = ed[i].w;
			for (int j = 0; j < 2; ++j) {
				if (d[v] == d[u] + w) {
					h[u].pb(mp(v, i));
					hT[v].pb(mp(u, i));
				}
				swap(u, v);
			}			
		}
		
		memset(was, 0, sizeof(was));
		dfsT(n - 1);
		
		vector<pii> a;
		for (int i = 0; i < n; ++i) {
			a.pb(mp(d[i], i));
		}
		sort(all(a));
		
		int cnt = 0;
		for (int i = 0; i < n; ++i) {
			int u = a[i].sc;
			if (d[u] >= inf) {
				break;
			}
			int e = 0;
			for (int j = 0; j < sz(hT[u]); ++j) {
				int v = hT[u][j].fs;
				if (ok(v, u)) {
					++e;
				}
			}
			cnt -= e;
			e = 0;
			int idx = -1;
			for (int j = 0; j < sz(h[u]); ++j) {
				int v = h[u][j].fs;
				if (ok(u, v)) {
					++e;
					idx = h[u][j].sc;
				}
			}
			if (e == 1 && cnt == 0) {
				ans.pb(idx);
			}
			cnt += e;
		}
	}
	
	void clear () {
		*this = Solution();
	}
};

Solution sol;
int main () {
	cout.precision(20);
	cout.setf(ios::fixed | ios::showpoint);
#ifdef SG
	freopen("d.in", "r", stdin);
//	freopen("", "w", stdout);
	while (sol.read()) {
		sol.solve();
		sol.write();
		sol.clear();
	}
#else
	sol.read();
	sol.solve();
	sol.write();
#endif

	return 0;
}
